// I need to watch a video on how to create a Chrome web plugin, so that i can finish my mini project today.


const DEFAULT_VALUES = {
    blockedWebsites: ["facebook.com", "youtube.com", "twitter.com"],
    blockedWeekdays: ["monday", "tuesday", "wednesday", "thursday", "friday"],
    blockedFromTime: "09:00",
    blockedToTime: "17:00"
    // ... more default values ...
};

// default values
let blockedWebsites;
let blockedWeekdays;
let blockedFromTime;
let blockedToTime;
const popupContainer = document.createElement('div');
const blurOverlay = document.createElement('div');
const shadowRoot = popupContainer.attachShadow({mode: 'open'});

// const server = 'http://localhost:5000';

const server = 'https://ai-prototypes-backend.onrender.com';


async function containsTargetDomain() {
    const url = window.location.hostname;
    // const result = await chrome.storage.sync.get(["blockedWebsites"])
    // console.log("result: " + result.blockedWebsites);
    // blockedWebsites = result.blockedWebsites;
    blockedWebsites = blockedWebsites.map((website) => website.toLowerCase());
    for (let i = 0; i < blockedWebsites.length; i++) {
        if (url.toLowerCase().includes(blockedWebsites[i])) {
            return true;
        }
    }
    return false;


}

async function inTimeRange() {
    // let result;
    // result = await chrome.storage.sync.get(['blockedWeekdays'])
    // blockedWeekdays = result.blockedWeekdays
    //
    // result = await chrome.storage.sync.get(['blockedFromTime'])
    // blockedFromTime = result.blockedFromTime
    //
    // result = await chrome.storage.sync.get(['blockedToTime'])
    // blockedToTime = result.blockedToTime


    // Get current time
    const now = new Date();
    const currentHour = now.getHours();
    const currentMinute = now.getMinutes();
    const currentTime = currentHour + ":" + currentMinute;

    console.log("currentTime: " + currentTime);
    console.log("blockedFromTime: " + blockedFromTime);
    console.log("blockedToTime: " + blockedToTime);

    //check if current time is in range
    if (!(currentTime >= blockedFromTime && currentTime <= blockedToTime)) {
        return false;
    }

    function getWeekdayName() {
        let weekdays = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
        return weekdays[now.getDay()];
    }

    // get weekday
    const weekday = getWeekdayName();

    console.log("weekday: " + weekday);
    console.log("blockedWeekdays: " + blockedWeekdays);
    blockedWeekdays = blockedWeekdays.map((day) => day.toLowerCase());

    // check if weekday is in blockedWeekdays
    if (!blockedWeekdays.includes(weekday.toLowerCase())) {
        return false;
    }

    return true;


}

load_user_data()
    .then(async () => {
        const blockedSite = await containsTargetDomain();
        const inTime = await inTimeRange();
        if (blockedSite && inTime) {
            block_content()
        }
    });

function block_content() {

    console.log("chrome storage: " + chrome.storage.sync)
    console.log("chrome storage: " + chrome.storage.sync.get('blockedWebsites', function (result) {
        console.log("result: " + result.blockedWebsites);
        blockedWebsites = result.blockedWebsites;
    }));
    // Create the blur overlay
    blurOverlay.classList.add("blur-overlay");
    blurOverlay.style.cssText = `
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    z-index: 10000;
    pointer-events: auto;
  `;
    document.body.appendChild(blurOverlay);

    // Create the pop-up window
    fetch(chrome.runtime.getURL('./popup.css'))
        .then(response => response.text())
        .then(data => {
            const style = document.createElement('style');
            style.textContent = data;
            shadowRoot.appendChild(style);
            console.log("set style")

        })


    // fetch content from file and set to innerHTML
    const content = document.createElement('div');
    fetch(chrome.runtime.getURL('./popup.html'))
        .then(response => response.text())
        .then(data => {
            content.innerHTML = data;
            console.log("set innerHTML")
            shadowRoot.getElementById("logo").src = chrome.runtime.getURL('./images/blocker.svg');

        })
    shadowRoot.appendChild(content);
    document.body.appendChild(popupContainer);

    on_popup_load();


}

function close_popup() {
    blurOverlay.remove();
    popupContainer.remove();
    document.removeEventListener('keydown', stopKeypressPropagation, false);
}

function stopKeypressPropagation(e) {
    e.stopPropagation();
}

function on_popup_load() {
    shadowRoot.addEventListener('keydown', stopKeypressPropagation, false);

    shadowRoot.addEventListener("input", function (e) {
        console.log("input event");

        const target = e.target.closest("#userInput");
        if (target) {
            const btn = shadowRoot.getElementById('sendButton');
            if (btn !== null) {
                console.log("remove disabled");
                btn.removeAttribute("disabled");
            } else {
                console.log("btn is null");
            }
        }


    });

    shadowRoot.addEventListener("click", async function (e) {
        console.log("click event");
        const target = e.target.closest("#sendButton"); // make a request to your server to upload the file using FormData and fetch

        if (target) {
            const userInput = shadowRoot.getElementById('userInput').value;
            const answer = shadowRoot.getElementById('answer');
            const status = await stream_content(userInput, answer);
            if (status.toLowerCase() === "accepted") {
                // pause for two seconds before executing the following code

                setTimeout(function () {
                    close_popup();
                }, 1500);
            }
        }
    });


    function decodeMultiple(str) {

        let parts = str.split('}{');

        // add back the brackets
        for (let i = 0; i < parts.length; i++) {
            if (i !== 0) {
                parts[i] = '{' + parts[i];
            }

            if (i !== parts.length - 1) {
                parts[i] = parts[i] + '}';
            }
        }
        let remainder = '';
        if (!str.endsWith('}')) {
            remainder = parts.pop();
        }

        let result = [];
        for (const part of parts) {
            result.push(JSON.parse(part));
        }
        return {
            result: result,
            remainder: remainder,
        }
    }

    async function* streamFetch(server, params) {
        const request = new Request(server, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(params),
        });

        const response = await fetch(request);

        if (!response.body) {
            throw new Error('No ReadableStream available');
        }

        const reader = response.body.getReader();
        const textDecoder = new TextDecoder();
        let remainder = '';

        while (true) {
            const {done, value} = await reader.read();
            if (done) {
                break;
            }
            try {
                console.log(textDecoder.decode(value))
                const res = decodeMultiple(remainder + textDecoder.decode(value));
                for (const part of res.result) {
                    yield part;
                }
                remainder = res.remainder;
            } catch (error) {
                console.error(`Error while parsing data: ${error} value was ${value}`);
            }
        }
    }

    async function stream_content(userInput, answer) {
        await load_user_data()
        const params = {
            userInput: userInput,
            blockedPages: blockedWebsites.join(", "),
            currentPage: window.location.href
        }
        let answer_so_far = ""

        for await (const data of streamFetch(server + "/blocksite", params)) {
            answer_so_far += data.c;
            answer.innerHTML = '';
            for (const line of answer_so_far.split(/\n+/)) {
                answer.innerHTML += `<p>${line.trim()}</p>`;
            }
        }
        return answer_so_far;

    }
}

async function load_user_data() {
    let data;

    // Load blocked sites
    data = await chrome.storage.sync.get(["blockedWebsites"])
    if (data.blockedWebsites) {
        blockedWebsites = data.blockedWebsites;
    } else {
        blockedWebsites = DEFAULT_VALUES.blockedWebsites;
    }

    // Load checked weekdays
    data = await chrome.storage.sync.get(["blockedWeekdays"])
    if (data.blockedWeekdays) {
        blockedWeekdays = data.blockedWeekdays;
    } else {
        blockedWeekdays = DEFAULT_VALUES.blockedWeekdays;
    }

    // Load from_time
    data = await chrome.storage.sync.get(["blockedFromTime"])
    if (data.blockedFromTime) {
        blockedFromTime = data.blockedFromTime;
    } else {
        blockedFromTime = DEFAULT_VALUES.blockedFromTime;
    }

    // Load to_time
    data = await chrome.storage.sync.get(["blockedToTime"])
    if (data.blockedToTime) {
        blockedToTime = data.blockedToTime;
    } else {
        blockedToTime = DEFAULT_VALUES.blockedToTime;
    }

}