const DEFAULT_VALUES = {
    blockedWebsites: ["facebook.com", "youtube.com", "twitter.com"],
    blockedWeekdays: ["monday", "tuesday", "wednesday", "thursday", "friday"],
    blockedFromTime: "09:00",
    blockedToTime: "17:00"
    // ... more default values ...
};
const saveButton = document.getElementById('saveButton');
const resetButton = document.getElementById('resetButton');

const blockedWebsites = document.getElementById("blockedWebsites");
const checkboxes = document.querySelectorAll('input[type=checkbox]');
const blockedFromTime = document.getElementById("blockedFromTime");
const blockedToTime = document.getElementById("blockedToTime");
// Get all the input and textarea elements
const inputs = document.querySelectorAll('input, textarea');


// if user data was previously saved, display it again here
document.addEventListener("DOMContentLoaded", function () {
    console.log("DOM fully loaded and parsed");
    set_user_data().then(() => {
        console.log("user data set");
        console.log("blockedFromTime: " + blockedFromTime.value);
        if (!all_values_default()) {
            resetButton.disabled = false; // Enable the reset button
        }
    });
});

// Add an event listener to each input and textarea element
inputs.forEach((input) => {

    input.addEventListener('input', () => {
        saveButton.disabled = false; // Enable the save button
        resetButton.disabled = false; // Enable the reset button

    });
});

saveButton.addEventListener("click", function () {
    save_values().then(() => {
        // close the popup
        window.close();
    });
});
resetButton.addEventListener("click", function () {
    // reset everything to default
    set_default_values().then(() => {
        resetButton.disabled = true; // Disable the reset button
        saveButton.disabled = true
        // close the popup
        window.close();
    });
});

async function save_values() {

    // get blocked sites from textarea
    const blockedWebsites = document.getElementById("blockedWebsites").value.split("\n")
    await chrome.storage.sync.set({blockedWebsites: blockedWebsites});
    console.log("blockedWebsites: " + blockedWebsites);

    // get checked values from checkboxes
    let checkedValues = [];

    for (let i = 0; i < checkboxes.length; i++) {
        if (checkboxes[i].checked) {
            checkedValues.push(checkboxes[i].value);
        }
    }
    await chrome.storage.sync.set({blockedWeekdays: checkedValues});
    console.log("checkedValues: " + checkedValues);

    // get start and end times
    await chrome.storage.sync.set({blockedFromTime: blockedFromTime.value});
    console.log("from_time: " + blockedFromTime.value);

    await chrome.storage.sync.set({blockedToTime: blockedToTime.value});
    console.log("to_time: " + blockedToTime.value);

    // disable the save button
    saveButton.disabled = true; // Disable the save button
}

async function set_default_values() {
    // set html elements to default
    blockedWebsites.value = DEFAULT_VALUES.blockedWebsites.join("\n");
    for (var i = 0; i < checkboxes.length; i++) {
        if (DEFAULT_VALUES.blockedWeekdays.includes(checkboxes[i].value)) {
            checkboxes[i].checked = true;
        } else {
            checkboxes[i].checked = false;
        }
    }
    blockedFromTime.value = DEFAULT_VALUES.blockedFromTime;
    blockedToTime.value = DEFAULT_VALUES.blockedToTime;


    // set blocked sites to default
    await chrome.storage.sync.set({blockedWebsites: DEFAULT_VALUES.blockedWebsites});
    console.log("blockedWebsites: " + DEFAULT_VALUES.blockedWebsites);

    // set checked values to default
    await chrome.storage.sync.set({blockedWeekdays: DEFAULT_VALUES.blockedWeekdays});
    console.log("checkedValues: " + DEFAULT_VALUES.blockedWeekdays);

    // set start and end times to default
    await chrome.storage.sync.set({blockedFromTime: DEFAULT_VALUES.blockedFromTime});
    console.log("from_time: " + DEFAULT_VALUES.blockedFromTime);

    await chrome.storage.sync.set({blockedToTime: DEFAULT_VALUES.blockedToTime});
    console.log("to_time: " + DEFAULT_VALUES.blockedToTime);
}

async function set_user_data() {

    let data;

    // Load blocked sites
    data = await chrome.storage.sync.get(["blockedWebsites"])
    if (data.blockedWebsites) {
        blockedWebsites.value = data.blockedWebsites.join("\n");
    } else {
        blockedWebsites.value = DEFAULT_VALUES.blockedWebsites.join("\n");
    }

    // Load checked weekdays
    data = await chrome.storage.sync.get(["blockedWeekdays"])
    if (data.blockedWeekdays) {
        for (let i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = data.blockedWeekdays.includes(checkboxes[i].value.toLowerCase());
        }
    } else {
        for (let i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = DEFAULT_VALUES.blockedWeekdays.includes(checkboxes[i].value.toLowerCase());
        }
    }

    // Load from_time
    data = await chrome.storage.sync.get(["blockedFromTime"])
    if (data.blockedFromTime) {
        blockedFromTime.value = data.blockedFromTime;
    } else {
        blockedFromTime.value = DEFAULT_VALUES.blockedFromTime;
    }

    // Load to_time
    data = await chrome.storage.sync.get(["blockedToTime"])
    if (data.blockedToTime) {
        blockedToTime.value = data.blockedToTime;
    } else {
        blockedToTime.value = DEFAULT_VALUES.blockedToTime;
    }
}

function all_values_default() {


    // Iterate over all checkboxes to check if they are default
    for (let i = 0; i < checkboxes.length; i++) {
        if (checkboxes[i].checked) {
            if (!(DEFAULT_VALUES.blockedWeekdays.includes(checkboxes[i].value))) {
                console.log(checkboxes[i].value + " not in default values")
                return false;
            }
        } else {
            if (DEFAULT_VALUES.blockedWeekdays.includes(checkboxes[i].value)) {
                console.log(checkboxes[i].value + " not in default values")
                return false;
            }
        }
    }
    if (!(areAllWordsInOtherString(blockedWebsites.value, DEFAULT_VALUES.blockedWebsites.join("\n")) &&
        areAllWordsInOtherString(DEFAULT_VALUES.blockedWebsites.join("\n"), blockedWebsites.value))) {
        console.log("blockedWebsites not default")
        return false;
    }
    if (!(blockedFromTime.value === DEFAULT_VALUES.blockedFromTime)) {
        console.log("blockedFromTime not default")
        console.log(" blockedFromTime.value: " + blockedFromTime.value + " Default: " + DEFAULT_VALUES.blockedFromTime)
        return false;
    }
    if (!(blockedToTime.value === DEFAULT_VALUES.blockedToTime)) {
        console.log("blockedToTime not default")
        return false;
    }
    return true;
}


function areAllWordsInOtherString(str1, str2) {
    // Split the strings into arrays of words
    let words1 = str1.split(/\s+/).filter(word => word.length > 0);
    let words2 = str2.split(/\s+/).filter(word => word.length > 0);

    // For each word in words1, check if it's present in words2
    for (let word of words1) {
        if (!words2.includes(word)) {
            // If a word from words1 is not present in words2, return false
            return false;
        }
    }

    // If we've gone through all words without returning false, all words are present in words2
    return true;
}


